# zchg_gen_keys.py
from cryptography.hazmat.primitives.asymmetric import rsa
from cryptography.hazmat.primitives import serialization

# -------------------------
# Generate RSA 3072 key pair
# -------------------------
private_key = rsa.generate_private_key(public_exponent=65537, key_size=3072)
public_key = private_key.public_key()

# -------------------------
# Save private key (keep secret!)
# -------------------------
with open("zchg_private_key.pem", "wb") as f:
    f.write(
        private_key.private_bytes(
            encoding=serialization.Encoding.PEM,
            format=serialization.PrivateFormat.PKCS8,
            encryption_algorithm=serialization.NoEncryption()  # Or use password!
        )
    )

# -------------------------
# Save public key (distribute to clients)
# -------------------------
with open("zchg_public_key.pem", "wb") as f:
    f.write(
        public_key.public_bytes(
            encoding=serialization.Encoding.PEM,
            format=serialization.PublicFormat.SubjectPublicKeyInfo
        )
    )

print("✅ ZCHG RSA key pair generated!")
print("Private key: zchg_private_key.pem (keep secret!)")
print("Public key:  zchg_public_key.pem (can distribute)")
